	% Spectrum of down-sampled signal 
	clear all, close all 
	F = [0,0.1,0.3,1]; A = [0,1,0,0]; % Setting the input parameters for fir2   
	x = fir2(256, F, A);  % Original signal
	wT = linspace(0, pi, 512);
	for M = 1:4
		subplot(4,1,M)
		y = DOWN_SAMPLE(x, M); 	% Down-sampling 
		Y = fft(y,1024); 		% Computing the spectrum
		subplot(4,1,M),	PLOT_ABS_Z(wT, abs(Y(1:512)),strcat('Y_', int2str(M)))
%		ylabel(strcat('   |Y','_',int2str(M),'|'))
		text(0.45,0.3,strcat('M  = ',int2str(M))), grid on
	end
	xlabel('{\it\omegaT} [rad]');
	
